<?php 
/*
Template Name: Magazine Layout
*/
get_header() ?>

	<div id="container">
		<div id="content" class="hfeed">
			<div id="nav-above" class="navigation">

						<div class="content-meta">
							<div class="entry-summary"><?php 
									the_excerpt();
							?></div>
							<span class="subscribe"><?php _e('Posts Feed:', 'iodiir') ?><a href="<?php bloginfo('rss2_url') ?>" title="<?php _e('Subscribe via RSS', 'iodiir') ?>" rel="alternate" type="application/rss+xml" class="rsswidget"><img src="<?php bloginfo('siteurl') ?>/wp-includes/images/rss.png" alt="RSS" title="RSS Icon" /></a></span>
						</div>
					<?php 	$iodiir_page_for_posts = get_option('page_for_posts'); 
							if ($iodiir_page_for_posts) { ?>
							<ul>
								<?php wp_list_pages('depth=1&sort_column=menu_order&title_li=&child_of='. $iodiir_page_for_posts); ?>
							</ul>
						<?php } ?>
				
									</div>
<?php 	query_posts('showposts=1');
		the_post() ?>

			<div id="post-<?php the_ID(); ?>" class="<?php sandbox_post_class() ?>">
				<h3 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php printf(__('Permalink to %s', 'iodiir'), wp_specialchars(get_the_title(), 1)) ?>" rel="bookmark"><?php the_title(); ?></a></h3>
				<div class="entry-content entry-summary">
<?php if (function_exists('the_excerpt_reloaded')) { the_excerpt_reloaded (200, '<a><em><strong><abbr><acronym>', 'content', true, '<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>', true, 1, true); } else { the_excerpt('<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>'); } ?>
				</div>
				<div class="entry-meta">
					<?php printf(__('This entry was written by %1$s and posted on <abbr class="published" title="%2$sT%3$s">%4$s at %5$s</abbr> and filed under %6$s.', 'iodiir'),
						'<span class="author vcard"><a class="url fn n" href="'.get_author_link(false, $authordata->ID, $authordata->user_nicename).'" title="View all posts by ' . $authordata->display_name . '">'.get_the_author().'</a></span>',
						get_the_time('Y-m-d'),
						get_the_time('H:i:sO'),
						the_date('', '', '', false),
						get_the_time(),
						get_the_category_list(', ') ) ?>
					<?php the_tags(__('<span class="entry-tags">Tagged ', 'sandbox'), ", ", "</span>") ?>&nbsp; 
					<span class="entry-commentlink"><?php comments_popup_link(__('Comments (0)', 'iodiir'), __('Comments (1)', 'iodiir'), __('Comments (%)', 'iodiir')) ?></span>.
				</div>				
			</div><!-- .post -->
			<div class="headlines">
				<h3><?php _e('Recent Posts', 'iodiir') ?></h3>

<?php	query_posts('showposts=4&offset=1');
		while ( have_posts() ) : the_post() ?>
			<div class="content-column left"><h4><a href="<?php the_permalink() ?>" title="<?php printf(__('Permalink to %s', 'iodiir'), wp_specialchars(get_the_title(), 1)) ?>" rel="bookmark"><?php the_title(); ?></a></h4>
				<div class="entry-meta">
					<abbr class="published" title="<?php the_time('Y-m-d\TH:i:sO'); ?>"><?php unset($previousday); printf(__('%1$s &#8211; %2$s', 'iodiir'), the_date('', '', '', false), get_the_time()) ?></abbr>
					<span class="meta-sep">|</span>
					<span class="entry-commentlink"><?php comments_popup_link(__('Comments (0)', 'iodiir'), __('Comments (1)', 'iodiir'), __('Comments (%)', 'iodiir')) ?></span>
				</div>
				<div class="entry-content entry-summary">
					<?php if (function_exists('the_excerpt_reloaded')) { the_excerpt_reloaded (50, '<a><em><strong><abbr><acronym>', 'content', true, '<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>', true, 1, true); } else { the_excerpt('<span class="more-link">'.__('Keep Reading &rarr;', 'iodiir').'</span>'); } ?>
				</div>
			</div>
<?php 	endwhile ?>
				<h3><a href="<?php 	global $iodiir_page_for_posts;
									$iodiir_blog_page = get_post($iodiir_page_for_posts, Array_A);
									echo $iodiir_blog_page->guid;
									?>" title="<?php
									_e('Previous Entries', 'iodiir') 
									?>" rel="bookmark"><?php 
									_e('Older Posts', 'iodiir') 
									?></a> &rarr;</h3>
			</div>
		</div><!-- #content .hfeed -->
	</div><!-- #container -->

<?php get_sidebar(); ?>
<?php get_footer() ?>