<?php 
if (!defined('ABSPATH'))
	exit("Sorry, you are not allowed to access this page directly.");

// ===========================================================================
// Foundation
// ===========================================================================

class HackadelicContext
{
	var $CTXID = 'hackadelic';

	function HackadelicContext($uniqueID='hackadelic') {
		assert($uniqueID);//, 'A unique, non-empty context id must be supplied';
		$this->CTXID = $uniqueID;
	}

	// I18N -------------------------------------------------------------------------------

	function t($s) { return __($s, $this->CTXID);	}
	function e($s) { _e($s, $this->CTXID);	}

	// Option Access ----------------------------------------------------------------------

	function fullname($name) {
		return $this->CTXID . '__' . $name;
	}
	//function getoption($name, $default=null) {
	//	$name = $this->fullname($name);
	//	$value = get_option($name);
	//	return $value != null ? $value : $default;
	//}
	//function setoption($name, $value) {
	//	$name = $this->fullname($name);
	//	update_option($name, $value);
	//}
	//function deloption($name) {
	//	$name = $this->fullname($name);
	//	delete_option($name);
	//}
	function load_option(&$option, $name) {
		$name = $this->fullname($name);
		$value = get_option($name);
		if (!$value) return false;
		$option = $value;
		return true;
	}
	function save_option(&$option, $name) {
		$name = $this->fullname($name);
		update_option($name, $option);
	}
	function erase_option(&$option, $name) {
		$name = $this->fullname($name);
		delete_option($name);
		$option = null;
	}
}

//---------------------------------------------------------------------------------------------

class HackadelicBase extends HackadelicContext
{
	function editurl($post) { echo admin_url('post.php?action=edit&post='.$post->ID); }
	function viewurl($post) { echo get_permalink($post->ID); }

	function admin_button($title, $onclick='', $type='button', $hint='') {
		if ($onclick) { $onclick = " onclick=\"$onclick\""; }
	?><span class="submit" style="border: 0 none">
		<input type="<?php echo $type ?>" value="<?php echo $title ?>"<?php echo $onclick ?> title="<?php echo $hint ?>" />
	</span> <?php
	}
	function admin_link_button($title, $onclick='', $class='', $hint='') {
		if ($onclick) { $onclick = " onclick=\"$onclick\""; }
		if ($class) { $class = " $class"; }
		echo '<a class="button'.$class.'"'.$onclick.' title="'.$hint.'">'.$title.'</a>';
	}
}

//---------------------------------------------------------------------------------------------

class HackadelicSeriesBase extends HackadelicBase
{
	var $PLUGIN_TITLE = 'Hackadelic Series';
	var $META_KEY = 'series';
	//var $META_KEY = 'Serial'; // For compatibility with "Serial Posts" plugin

	//-------------------------------------------------------------------------------------

	function HackadelicSeriesBase() {
		parent::HackadelicBase('HackadelicSeries');
		$this->load_option($this->META_KEY, 'META_KEY');
	}

	//function setup() { }
}

// ===========================================================================
// Series Front End
// ===========================================================================

class HackadelicSeriesFrontend extends HackadelicSeriesBase
{
	var $MAIN_INTRO = 'This entry is part of a series, ';
	var $LIST_INTRO = 'Entries in this series:';

	//-------------------------------------------------------------------------------------

	function setup() {
		$this->load_option($this->MAIN_INTRO, 'MAIN_INTRO');
		$this->load_option($this->LIST_INTRO, 'LIST_INTRO');

		$this->MAIN_INTRO = $this->t($this->MAIN_INTRO);
		$this->LIST_INTRO = $this->t($this->LIST_INTRO);

		if (is_admin())
			add_action('admin_menu', array(&$this, 'addAdminMenu'));
		else
			add_filter('the_content', array(&$this, 'processContent'), 10);
	}

	//-------------------------------------------------------------------------------------

	function processContent($content) {
		$isSingle = is_single();
		//if (!$isSingle) return $content;

		global $id;
		$meta = get_post_meta($id, $this->META_KEY);
		if (!$meta) return $content;
		$series = array();
		foreach ($meta as $each) {
			$series[] = "[slider title=\"$each\"]"
			          . $this->listPosts($this->entriesIn($each), $id)
			          . "[/slider]";
		}
		$series = join(', ', $series);
		$class = $isSingle ? 'hackadelic-series-info' : 'hackadelic-series-info on-frontpage';
		$series = "<div class=\"$class\"><small>$this->MAIN_INTRO $series</small></div>";
		//$series = do_shortcode($series); // no need, shortcodes will be processed at prio 11
		return $series . $content;
		//return $isSingle ? $content . $series : $series . $content;
	}

	//-------------------------------------------------------------------------------------

	function listPosts($posts, $currentID=-1) {
		$items = '';
		foreach ($posts as $post) {
			$url = get_permalink($post->ID);
			$title = $post->status != 'publish' ? "<em>$post->title</em>" : $post->title;
			$items .= ($post->ID != $currentID) 
			        ? "<li><a href=\"$url\">$title</a></li>"
			        : "<li>$title</li>";
		}
		return $items ? $this->LIST_INTRO . "<ol>$items</ol>" : $items;
	}

	//-------------------------------------------------------------------------------------

	function entriesIn($series, $exceptID=-1) {
		global $wpdb;
		$key = $this->META_KEY;
		$precond = current_user_can('edit_posts') ? ' ' : " post_status = 'publish' AND";
		return $wpdb->get_results(
			"SELECT ID, post_title title, post_status status"
			." FROM $wpdb->posts JOIN $wpdb->postmeta ON ID=post_id"
			." WHERE$precond meta_key = '$key' AND meta_value = '$series'"
			." AND ID != $exceptID"
			." ORDER BY post_date_gmt ASC"
			);
	}

	//-------------------------------------------------------------------------------------

	function addAdminMenu() {
		$title = $this->PLUGIN_TITLE;
		add_options_page($title, $title, 10, __FILE__, array(&$this, 'displayOptionsPage'));
	}

	//-------------------------------------------------------------------------------------

	function displayOptionsPage() {
		include 'hackadelic-series-settings-page.php';
	}
}

// ===========================================================================
// Series Admin
// ===========================================================================

class HackadelicSeries
{
	var $members = array();
}

//---------------------------------------------------------------------------------------------

class HackadelicSeriesAdmin extends HackadelicSeriesBase
{
	function handleRequest(&$msg) {
		global $wpdb;
		$meta_key = $this->META_KEY;
		$action = $_REQUEST['action'];
		if ($action == 'rename')
		{
			$from = $_REQUEST['from'];
			$to = $_REQUEST['to'];
			if ($from == $to) return 0;
			$sql = "UPDATE $wpdb->postmeta SET meta_value = '$to'"
				 . " WHERE meta_key = '$meta_key' AND meta_value = '$from'";
			$ndb = $wpdb->query($sql);
			$msg = $this->t('Series')." &quot;$from&quot; "
				 . $this->t('renamed to')." &quot;$to&quot;, $ndb "
				 . $this->t('entries updated').'.';
			return $ndb;
		}
		elseif ($action == 'migrate-meta')
		{
			$from = $_REQUEST['from'];
			$to = $_REQUEST['to'];
			if ($from == $to) return 0;
			$sql = "UPDATE $wpdb->postmeta SET meta_key = '$to'"
				 . " WHERE meta_key = '$from'";
			$ndb = $wpdb->query($sql);
			$msg = $this->t('Meta key')." &quot;$from&quot; "
				 . $this->t('renamed to')." &quot;$to&quot;, $ndb "
				 . $this->t('entries updated').'.';
			$this->META_KEY = $to;
			$this->save_option($this->META_KEY, 'META_KEY');
			return $ndb;
		}
		else
			return -1;
	}

	//-------------------------------------------------------------------------------------

	function groupEntries() {
		global $wpdb;
		$meta_key = $this->META_KEY;
		$posts = $wpdb->get_results(
			"SELECT ID, post_title title, meta_value series, post_status status"
		    ." FROM $wpdb->posts JOIN $wpdb->postmeta ON ID=post_id"
			." WHERE meta_key = '$meta_key'"
			." ORDER BY meta_value, post_date_gmt ASC"
			);
		$index = '';
		$allseries = array();
		$current = null;
		foreach ($posts as $p) {
			if ($p->series != $index) {
				$index = $p->series;
				$current =& new HackadelicSeries();
				$allseries[$index] =& $current;
			}
			$current->members[] = $p;
		}
		return $allseries;
	}

	//-------------------------------------------------------------------------------------

	function setup() {
		add_action('admin_menu', array(&$this, 'addAdminMenu'));
	}

	//-------------------------------------------------------------------------------------

	function addAdminMenu() {
		$title = $this->PLUGIN_TITLE;
		add_management_page($title, $title, 10, __FILE__, array(&$this, 'displayAdminPage'));
	}

	//-------------------------------------------------------------------------------------

	function displayAdminPage() {
		include 'hackadelic-series-admin-page.php';
	}
}
?>