<?php

define('Starscape_Version', '1.5.10');
define('Starscape_Revision', '258');
define('Starscape_Status', 'Final');
define('Starscape_Edition', 'Scorpius');

define('Starscape_Upgrade_Url', 'http://upgrade.starscapetheme.com/check.php');

class Starscape {
    var $log_file;

    var $options;
    var $update;
    var $sociable;
    var $nova;
    var $classic;
    var $active_wp_page;

    var $default_options = array(
        'version' => Starscape_Version,
        'revision' => Starscape_Revision,
        'status' => Starscape_Status,
        'edition' => Starscape_Edition,
        'engine' => 1,
        'engine_name' => 'nova',
        'favicon' => 'starscape.ico',
        'icon_set' => 'famfamfam',
        'icon_set_extra' => 1,
        'front_excerpts' => 0,
        'main_menu' => 1,
        'main_menu_home' => 1,
        'main_menu_align' => 'right',
        'main_menu_transparency' => 1,
        'main_menu_cc' => 1,
        'main_menu_color' => 'ffffff',
        'top_menu_cc' => 1,
        'top_menu_color' => 'ffffff',
        'sidebar_footer' => 1,
        'sidebar_left' => 1,
        'sidebar_right' => 1,
        'sidebar_footer_size' => 3,
        'sidebar_left_width' => 180,
        'sidebar_right_width' => 180,
        'search_form' => 1,
        'search_form_bottom' => 0,
        'search_form_google' => 0,
        'search_form_google_bottom' => 0,
        'datebutton_style' => 3,
        'datebutton_post' => 1,
        'datebutton_page' => 1,
        'datebutton_align' => 0,
        'datebutton_round' => 1,
        'footer_xhtml' => 1,
        'footer_css' => 1,
        'footer_wp' => 1,
        'footer_style' => 1,
        'top_menu' => 1,
        'top_menu_items' => 'HLARS',
        'top_menu_align' => 'right',
        'top_menu_icons' => 1,
        'top_menu_forum' => 'http://',
        'top_menu_newpost_log' => 1,
        'top_menu_reg_log' => 1,
        'top_menu_login_log' => 1,
        'top_menu_admin_log' => 1,
        'header_header' => 'txt',
        'header_title' => 1,
        'header_subtitle' => 1,
        'header_align' => 'left',
        'header_valign' => 'top',
        'header_logo' => '_',
        'header_logo_pad_left' => 30,
        'header_logo_pad_right' => 30,
        'header_title_height' => 6,
        'header_subtitle_height' => 2.4,
        'header_title_cc' => 1,
        'header_title_color' => 'ffff00',
        'header_subtitle_cc' => 1,
        'header_subtitle_color' => 'ffffff',
        'gravatar_comment' => -1,
        'gravatar_author' => -1,
        'gravatar_rating' => 'G',
        'tags_post' => 1,
        'tags_page' => 1,
        'tags_front' => 1,
        'tags_archive' => 1,
        'tags_location' => 'bottom',
        'print_post' => 1,
        'print_page' => 1,
        'print_with_comments' => 1,
        'posts_navigation' => 'star',
        'posts_comments' => 'ct',
        'posts_trackbacks' => 'mixed',
        '404_selected' => 'classic',
        '404_search' => 1,
        'ga_active' => 0,
        'ga_code' => '',
        'postauthor_active_post' => 1,
        'postauthor_active_page' => 1,
        'postauthor_contact_email' => 1,
        'postauthor_contact_other' => 1,
        'postauthor_recent_date' => 1,
        'postauthor_recent_comments' => 1,
        'author_titles' => 1,
        'author_posts_page' => 10,
        'author_contact_email' => 1,
        'author_contact_other' => 1,
        'related_active' => 1,
        'related_number' => 5,
        'related_cats' => 1,
        'related_date' => 1,
        'related_comments' => 1,
        'add_comment_button' => 0,
        'gdsr_integrate_standard' => 0,
        'gdsr_integrate_multis' => 0,
        'gdsr_integrate_multis_set' => 0,
        'gdsr_integrate_multis_tpl' => 0,
        'gdsr_integrate_multis_tpl_display' => 0,
        'gdsr_override_standard' => 0,
        'gdsr_override_multis' => 0,
        'gdsr_comment_rating' => 0,
        'page_comments' => 0
    );

    var $default_classic = array(
        'style' => 0,
        'style_color' => 0,
        'style_name' => 'Blue',
        'style_round_top' => 1,
        'style_round_bottom' => 1,
        'style_white' => 1,
        'style_shadow' => 1,
        'header_background' => '_',
        'header_background_color' => 'ffffff',
        'header_height_custom' => 1,
        'header_height' => 140,
        'header_height_background' => 140
    );

    var $default_nova = array(
        'width_type' => 'fixed',
        'global_width' => 950,
        'header_width' => 0,
        'header_height' => 150,
        'header_image' => 'star_scorpius.png',
        'header_color' => '661212',
        'main_menu_width' => 0,
        'main_menu_height' => 28,
        'main_menu_image' => '_',
        'main_menu_color' => 'ffffff',
        'main_menu_color_use' => 0,
        'center_width' => 0,
        'center_valign' => 'top',
        'center_image' => 'star_scorpius.png',
        'center_color' => 'fff0c2',
        'footer_width' => 0,
        'footer_image' => '_',
        'footer_color' => 'ff7e00',
        'foobar_image' => '_',
        'foobar_color' => 'ffa84b',
        'typography' => 2
    );

    var $default_sociable = array(
        'digg_active' => 0,
        'digg_style' => 'default',
        'digg_position' => '',
        'digg_align' => '',
        'digg_display_post' => 1,
        'digg_display_page' => 1,
        'digg_display_home' => 1
	);

    var $default_update = array(
        'last_check' => '',
        'last_available' => '',
        'last_response' => ''
    );

    function Starscape() {
        $this->log_file = dirname(__FILE__)."/debug.txt";
        $this->get_active_wp_page();

        if ($_POST['ss_action'] == 'reset') {
            $this->uninstall();
            $this->install();
        }

        if ($_POST['ss_action'] == 'update') {
            $this->update = $this->default_update;
            update_option('starscape_update', $this->default_update);
        }

        if ($_POST['ss_action'] == 'delete') {
            $this->uninstall();
            $this->unsetheme();
            wp_redirect('themes.php?activated=true');
            exit;
        }

        add_action('init', array(&$this, 'lang_init'));
        add_action('admin_menu', array(&$this, 'add_menu'));
        if ($this->active_wp_page)
            add_action('admin_head', array(&$this, 'admin_head'));

        if (!is_array(get_option('starscape')))
            $this->install();

        $this->options = get_option('starscape');
        $this->update = get_option('starscape_update');
        $this->sociable = get_option('starscape_sociable');
        $this->nova = get_option('starscape_nova');
        $this->classic = get_option('starscape_classic');

        if ($this->toupgrade($this->options["version"], Starscape_Version))
            $this->upgrade();

        if ($this->options["gravatar_comment"] == -1)
            $this->defaultgravatar();

        $this->initsidebars();
        $this->getupgradedata();
    }

    function dump($msg, $object, $mode = "a+") {
        $obj = print_r($object, true);
        $f = fopen($this->log_file, $mode);
        fwrite ($f, sprintf("[%s] : %s\r\n", current_time('mysql'), $msg));
        fwrite ($f, "$obj");
        fwrite ($f, "\r\n");
        fclose($f);
    }

    function get_active_wp_page() {
        if (stripos($_GET["page"], "starscape") === false) $this->active_wp_page = false;
        else $this->active_wp_page = true;
    }

    function defaultgravatar() {
        $this->options["gravatar_comment"] = get_option("show_avatars");
        $this->options["gravatar_author"] = get_option("show_avatars");
        $this->options["gravatar_rating"] = get_option("avatar_rating");

        update_option('starscape', $this->options);
    }

    function toupgrade($old, $new) {
        $lst_old = explode('.', $old);
        $lst_new = explode('.', $new);

        if (intval($lst_new[0]) > intval($lst_old[0]))
            return true;
        if (intval($lst_new[1]) > intval($lst_old[1]))
            return true;
        if (intval($lst_new[2]) > intval($lst_old[2]))
            return true;
        return false;
    }

    function add_menu() {
        add_theme_page('Starscape Options', 'Starscape', 'edit_themes', "starscape", array(&$this, 'optionsmenu'));
    }

    function lang_init() {
        $currentLocale = get_locale();
        if(!empty($currentLocale)) {
            $moFile = TEMPLATEPATH."/languages/starscape-theme-".$currentLocale.".mo";
            if (@file_exists($moFile) && is_readable($moFile)) load_textdomain('starscape-theme', $moFile);
        }
    }

    function admin_head() {
        echo'<link rel="stylesheet" href="'.get_bloginfo('template_url').'/code/css/admin.css" type="text/css" media="screen" />';
        echo'<link rel="stylesheet" href="'.get_bloginfo('template_url').'/code/css/tabber.css" type="text/css" media="screen" />';
        echo'<script type="text/javascript" src="'.get_bloginfo('template_url').'/code/js/tabber.js"></script>';
        echo'<script type="text/javascript" src="'.get_bloginfo('template_url').'/code/js/options.js.php"></script>';
        ?>
            <script type="text/javascript">
                document.write('<style type="text/css">.tabber{display:none;}<\/style>');
            </script>
        <?php
    }

    function initsidebars() {
        if (function_exists('register_sidebar')) {
            register_sidebar(array(
                'name' => 'Sidebar Left',
                'before_widget' => '<li id="%1$s" class="widget %2$s">',
                'after_widget' => '</li>',
                'before_title' => '<h2 class="widgettitle">',
                'after_title' => '</h2>'));

            register_sidebar(array(
                'name' => 'Sidebar Right',
                'before_widget' => '<li id="%1$s" class="widget %2$s">',
                'after_widget' => '</li>',
                'before_title' => '<h2 class="widgettitle">',
                'after_title' => '</h2>'));

            register_sidebar(array(
                'name' => 'Footer',
                'before_widget' => '<td valign="top" id="%1$s" class="widget %2$s">',
                'after_widget' => '</td>',
                'before_title' => '<h2 class="widgettitle">',
                'after_title' => '</h2>'));
        }
    }

    function install() {
        add_option('starscape', $this->default_options, 'Starscape Options');
        add_option('starscape_update', $this->default_update, 'Starscape Updates');
        add_option('starscape_sociable', $this->default_sociable, 'Starscape Sociable');
        add_option('starscape_classic', $this->default_classic, 'Starscape Engine Classic');
        add_option('starscape_nova', $this->default_nova, 'Starscape Engine Nova');
    }

    function uninstall() {
        delete_option('starscape');
        delete_option('starscape_update');
        delete_option('starscape_sociable');
        delete_option('starscape_classic');
        delete_option('starscape_nova');
    }

    function unsetheme() {
        update_option('template', 'default');
        update_option('stylesheet', 'default');
        delete_option('current_theme');
        $theme = get_current_theme();
        do_action('switch_theme', $theme);
    }

    function upgrade() {
        if (!is_array($this->nova)) {
            $this->nova = $this->default_nova;
        }
        else {
            foreach ($this->default_nova as $key => $value) {
                if (!isset($this->nova[$key])) $this->nova[$key] = $value;
            }
        }

        if (!is_array($this->options)) {
            $this->options = $this->default_options;
        }
        else {
            foreach ($this->default_options as $key => $value) {
                if (!isset($this->options[$key])) $this->options[$key] = $value;
            }
        }

        if (!is_array($this->classic)) {
            $this->classic = $this->default_classic;
        }
        else {
            foreach ($this->default_classic as $key => $value) {
                if (!isset($this->classic[$key])) $this->classic[$key] = $value;
            }
        }

        if (!is_array($this->update)) {
            $this->update = $this->default_update;
        }
        else {
            foreach ($this->default_update as $key => $value) {
                if (!isset($this->update[$key])) $this->update[$key] = $value;
            }
        }

        if (!is_array($this->sociable)) {
            $this->sociable = $this->default_sociable;
        }
        else {
            foreach ($this->default_sociable as $key => $value) {
                if (!isset($this->sociable[$key])) $this->sociable[$key] = $value;
            }
        }

        $this->options["version"] = Starscape_Version;
        $this->options["revision"] = Starscape_Revision;
        $this->options["edition"] = Starscape_Edition;
        $this->options["status"] = Starscape_Status;

        update_option('starscape', $this->options);
        update_option('starscape_sociable', $this->sociable);
        update_option('starscape_update', $this->update);
        update_option('starscape_nova', $this->nova);
        update_option('starscape_classic', $this->classic);
    }

    function getpages() {
        global $wpdb;
        $sql = "SELECT x.id, x.post_title as title FROM ".$wpdb->posts." x WHERE x.post_type = 'page' AND x.post_status = 'publish' AND x.post_parent = 0 ORDER BY x.menu_order, x.id";
        if ($subpages = $wpdb->get_results($sql, ARRAY_A))
            return $subpages;
        else
            return array();
    }

    function optionsmenu() {
        require_once(TEMPLATEPATH."/styles/styles.php");

        $sso = $this->options;
        $ssec = $this->classic;
        $ssen = $this->nova;
        $sss = $this->sociable;

        include(TEMPLATEPATH.'/code/starscape_saveform.php');
        include(TEMPLATEPATH.'/code/starscape_options.php');
    }

    function geticon($name) {
        $iconurl = "";
        if ($this->options["icon_set_extra"] == 1) {
            $iconurl = get_bloginfo('template_url')."/styles/icons/".$this->options["icon_set"]."/icon_";
            $iconurl = sprintf('<img src="%s%s.png" alt="%s" class="png postelementimg" />', $iconurl, $name, $name);
        }
        return $iconurl;
    }

    // ### upgrade ###
    function getresponsefile($request) {
        $response = file(Starscape_Upgrade_Url.$request);
        return $response[0];
    }

    function getresponsecurl($request) {
        $ch = curl_init(Starscape_Upgrade_Url.$request);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    function getupgradedata() {
        $day = getdate();
        $today = $day["year"].$day["mon"].$day["mday"];

        if ($today != $this->update["last_check"]) {
            $request = "?v=".Starscape_Version."&b=".urlencode(get_option('home'));

            if (ini_get('allow_url_fopen') == 1) {
                $response = $this->getresponsefile($request);
            }
            else if (function_exists('curl_init')) {
                $response = $this->getresponsecurl($request);
            }
            else {
                $response = "e|For update check to work you need <u>cURL</u> extension enabled or to allow <u>allow_url_fopen</u> in <u>php.ini</u>.";
            }

            $update = explode("|", $response);
            if ($update == FALSE || strlen($update) == 0) {
                $this->update["last_check"] = '_';
                $this->update["last_available"] = 'e';
                $this->update["last_response"]= 'Error contacting upgrade server.';
            }
            else {
                $this->update["last_check"] = $today;
                $this->update["last_available"] = $update[0];
                $this->update["last_response"] = $update[1];
            }

            update_option('starscape_update', $this->update);
        }
    }
    // ### upgrade ###
}

?>