<?php

/*
Plugin Name: GD Pages Navigator
Plugin URI: http://www.dev4press.com/plugins/gd-pages-navigator/
Description: This widget can be used to change the way of navigating through your blog pages. PDF <a href="http://wp.gdragon.info/plugins/gd-pages-navigator/userguide/">User guide</a> contains detailed information about all plugin options.
Version: 3.8.1
Author: Milan Petrovic
Author URI: http://www.dev4press.com/

== Copyright ==

Copyright 2008 Milan Petrovic (email : milan@gdragon.info)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

require_once("gd-pages-functions.php");

class GDPagesNavigator {
    var $sort_types;
    
    var $default_options = array(
            'title' => 'Pages',
            'autoTitle' => 1, 
            'excludePages' => '',
            'removePages' => '',
            'levelUp' => 0,
            'upLocTop' => 0,
            'upIdent' => 0,
            'levelDepth' => 0,
            'renderType' => 1,
            'fhIdent' => 0,
            'identSize' => 5,
            'homeLink' => 'Home',
            'sortType' => 0,
            'sortOrder' => 'ASC',
            'classLevelUpList' => 'gdpn-levelup-list',
            'classLevelUpItem' => 'gdpn-levelup-item',
            'classPagesList' => 'gdpn-pages-list',
            'classPagesItem' => 'gdpn-pages-item',
            'classChildList' => 'gdpn-child-list',
            'classChildItem' => 'gdpn-child-item',
            'rootPage' => 'gdpnav-rootPage',
            'special404' => 'hide',
            'specialSearch' => 'hide',
            'specialHome' => 'show',
            'specialPage' => 'show',
            'specialSingle' => 'show',
            'specialArchive' => 'show'
        );
    var $plugin_folder = '';
    var $wp_old = true;
    
    var $o;
     
    function GDPagesNavigator() {
        $this->sort_types = array(
            array('name'=>__('Menu Order', 'gd-pages-navigator'), 'value'=>'menu_order'),
            array('name'=>__('Page Title', 'gd-pages-navigator'), 'value'=>'post_title'),
            array('name'=>__('Page Slug', 'gd-pages-navigator'), 'value'=>'post_name'),
            array('name'=>__('Page ID', 'gd-pages-navigator'), 'value'=>'ID'),
            array('name'=>__('Creation Date', 'gd-pages-navigator'), 'value'=>'post_date'),
            array('name'=>__('Modification Date', 'gd-pages-navigator'), 'value'=>'post_modified')
        );
        $this->default_options['title'] = __('Pages', 'gd-pages-navigator');
        $this->default_options['homeLink'] = __('Home', 'gd-pages-navigator');

        $wp_version = str_replace('.', '', get_bloginfo('version'));
        $wp_version = substr($wp_version, 0, 2);
        if ($wp_version < 26)
                $this->plugin_folder = get_option('home').'/'.PLUGINDIR.'/gd-pages-navigator/';
        else {
                $this->plugin_folder = WP_PLUGIN_URL.'/gd-pages-navigator/';
                $this->wp_old = false;
        }
        add_action('admin_head', array(&$this, 'admin_head'));
        
        $this->upgrade(); 
    }
    
    function upgrade() {
        $options = get_option('widget_gdpagesnavigator');
        if (is_array($options)) {
            if (isset($options["title"])) {
                $options = array();
                update_option('widget_gdpagesnavigator', $options);
            }
        } 
    }
    
    function admin_head() {
        echo '<link rel="stylesheet" href="'.$this->plugin_folder.'gd-pages-styles.css" type="text/css" media="screen" />';
        echo '<script type="text/javascript" src="'.$this->plugin_folder.'gd-pages-script.js"></script>';
    }

    function init() {
        $currentLocale = get_locale();
        if(!empty($currentLocale)) {
                $moFile = dirname(__FILE__) . "/languages/gd-pages-navigator-" . $currentLocale . ".mo";
                if (@file_exists($moFile) && is_readable($moFile)) load_textdomain('gd-pages-navigator', $moFile);
        }
    }
	
    function widget_init() {
        if (!$options = get_option('widget_gdpagesnavigator'))
            $options = array();
            
        $widget_ops = array('classname' => 'widget_gdpagesnavigator', 'description' => 'GD Pages Navigator');
        $control_ops = array('width' => $this->wp_old ? 560 : 548, 'height' => 560, 'id_base' => 'gdnavmulti');
        $name = 'GD Pages Navigator';
        
        $registered = false;
        foreach (array_keys($options) as $o) {
            if (!isset($options[$o]['title']))
                continue;
            
            $id = "gdnavmulti-$o";
            $registered = true;
            wp_register_sidebar_widget($id, $name, array(&$this, 'widget'), $widget_ops, array( 'number' => $o ) );
            wp_register_widget_control($id, $name, array(&$this, 'control'), $control_ops, array( 'number' => $o ) );
        }
        if (!$registered) {
            wp_register_sidebar_widget('gdnavmulti-1', $name, array(&$this, 'widget'), $widget_ops, array( 'number' => -1 ) );
            wp_register_widget_control('gdnavmulti-1', $name, array(&$this, 'control'), $control_ops, array( 'number' => -1 ) );
        }
    }
    
    function widget($args, $widget_args = 1) {
        extract($args);
        global $post;

        if (is_numeric($widget_args))
            $widget_args = array('number' => $widget_args);
        $widget_args = wp_parse_args($widget_args, array( 'number' => -1 ));
        extract($widget_args, EXTR_SKIP);
        $options_all = get_option('widget_gdpagesnavigator');
        if (!isset($options_all[$number]))
            return;
        $this->o = $options_all[$number];

        if (($this->o["specialHome"] == "hide" && is_home()) || 
            ($this->o["special404"] == "hide" && is_404()) || 
            ($this->o["specialSearch"] == "hide" && is_search()) || 
            ($this->o["specialPage"] == "hide" && is_page()) || 
            ($this->o["specialArchive"] == "hide" && is_archive()) || 
            ($this->o["specialSingle"] == "hide" && is_single())) return;
        
        $title = $this->o['title'];
        $renderType = $this->o['renderType'];
        $sortType = $this->o['sortType'];
        $sortOrder = $this->o['sortOrder'];
        
        $roodIdToRender = $post->post_parent;

        $levelTop = "";
        $levelBottom = "";
        $level = "";
        $ident = "";
        $debug = "";

        $excludeList = isset($this->o['removePages']) ? explode(',', $this->o['removePages']) : array(); 

        if ($renderType == "1") {
            if (!is_page()) 
                $output = $this->render_level($excludeList, 0, 0, true, false, $sortType, $sortOrder, $this->o["classPagesList"], $this->o["classPagesItem"]);
            else {
                $exclude = isset($this->o['excludePages']) ? explode(',', $this->o['excludePages']) : array(); 
                if (in_array($post->ID, $exclude)) return;
                                
                $parent_page = get_post($post->post_parent);
                $subpages = count(GDPages::get_subpages_ids($post->ID));
                if ($subpages > 0) {
                    $roodIdToRender = $post->ID;
                    if ($this->o['autoTitle'] == 1)
                        $title = $post->post_title;
                }
                
                if ($this->o['autoTitle'] == 1 && $subpages == 0) {
                    if ($post->post_parent == 0)
                        $title = $this->o['title'];
                    else
                        $title = $parent_page->post_title;
                }
                    
                $level_page = $parent_page;
                if ($this->o["levelUp"] == 1) {
                	if ($post->post_parent == 0)
                		$level = '<ul class="'.$ul_class.'"><li class="page_item page-item-home '.$this->o['classLevelUpList'].'"><a href="'.get_option('home').'" title='.attribute_escape(apply_filters('the_title', $this->o['homeLink'])).'>'.apply_filters('the_title', $this->o['homeLink']).'</a></li></ul>';
                	else
                    	$level = '<ul class="'.$ul_class.'"><li class="page_item page-item-'.$level_page->ID.' '.$options['classLevelUpItem'].'"><a href="'.get_page_link($level_page->ID).'" title='.attribute_escape(apply_filters('the_title', $level_page->post_title)).'>'.apply_filters('the_title', $level_page->post_title).'</a></li></ul>';
                    
                    if ($this->o["upLocTop"] == 0) 
                        $levelTop = $level;
                    else 
                        $levelBottom = $level;
                }
                if ($this->o["upIdent"] == 1) 
                    $ident = $this->o["identSize"];
                
                $output = $this->render_level($excludeList, $roodIdToRender, $ident, true, true, $sortType, $sortOrder, $this->o["classPagesList"], $this->o["classPagesItem"]);
            }
        }
        if ($renderType == "2") {
            $output = $this->render_level($excludeList, 0, 0, true, false, $sortType, $sortOrder, $this->o["classPagesList"], $this->o["classPagesItem"]);
        }
        if ($renderType == "3") {
            $output = $this->render_level_hierarchy($excludeList, $this->o["fhIdent"] == 1 ? $this->o["identSize"] : 0, $sortType, $sortOrder, $this->o["classPagesList"], $this->o["classPagesItem"]);
        }
        if ($renderType == "4") {
            $output = $this->render_level($excludeList, $this->o["rootPage"], $ident, true, true, $sortType, $sortOrder, $this->o["classPagesList"], $this->o["classPagesItem"]);
        }
        
        if (!empty($output)) {
            echo $before_widget.$before_title;
            _e($title);
            echo $after_title.$levelTop.$output.$levelBottom.$after_widget;
        }
    }
    
    function control($widget_args = 1) {
        global $wp_registered_widgets;
        static $updated = false;

        if ( is_numeric($widget_args) )
            $widget_args = array('number' => $widget_args);
        $widget_args = wp_parse_args($widget_args, array('number' => -1));
        extract($widget_args, EXTR_SKIP);
        $options_all = get_option('widget_gdpagesnavigator');
        if (!is_array($options_all))
            $options_all = array();

        if (!$updated && !empty($_POST['sidebar'])) {
            $sidebar = (string)$_POST['sidebar'];

            $sidebars_widgets = wp_get_sidebars_widgets();
            if (isset($sidebars_widgets[$sidebar]))
                $this_sidebar =& $sidebars_widgets[$sidebar];
            else
                $this_sidebar = array();

            foreach ($this_sidebar as $_widget_id) {
                if ('widget_gdpagesnavigator' == $wp_registered_widgets[$_widget_id]['callback'] && isset($wp_registered_widgets[$_widget_id]['params'][0]['number'])) {
                    $widget_number = $wp_registered_widgets[$_widget_id]['params'][0]['number'];
                    if (!in_array("gdnavmulti-$widget_number", $_POST['widget-id']))
                        unset($options_all[$widget_number]);
                }
            }
            foreach ((array)$_POST['gdpnav'] as $widget_number => $posted) {
                if (!isset($posted['title']) && isset($options_all[$widget_number]))
                    continue;
                $options = array();
                $options['title'] = strip_tags(stripslashes($posted['title']));
                $options['excludePages'] = isset($posted['excludePages']) ? implode(',', $posted['excludePages']) : ''; 
                $options['removePages'] = isset($posted['removePages']) ? implode(',', $posted['removePages']) : ''; 
                $options['rootPage'] = isset($posted['rootPage']) ? implode(',', $posted['rootPage']) : ''; 
                $options['autoTitle'] = isset($posted['autoTitle']);
                $options['blogRoot'] = isset($posted['blogRoot']);
                $options['levelUp'] = isset($posted['levelUp']);
                $options['upIdent'] = isset($posted['upIdent']);
                $options['fhIdent'] = isset($posted['fhIdent']);
                $options['renderType'] = $posted['renderType'];
                if ($options['renderType'] == '1')
                    $options['identSize'] = $posted['identSize-1'];
                if ($options['renderType'] == '3')
                    $options['identSize'] = $posted['identSize-3'];
                $options['upLocTop'] = $posted['upLocTop'];
                $options['homeLink'] = $posted['hometitle'];
                $options['sortType'] = $posted['sortType'];
                $options['sortOrder'] = $posted['sortOrder'];
                $options['classLevelUpList'] = $posted['levelup-list'];
                $options['classLevelUpItem'] = $posted['levelup-item'];
                $options['classPagesList'] = $posted['pages-list'];
                $options['classPagesItem'] = $posted['pages-item'];
                $options['classChildList'] = $posted['child-list'];
                $options['classChildItem'] = $posted['child-item'];
                $options['specialHome'] = $posted['specialHome'];
                $options['special404'] = $posted['special404'];
                $options['specialSearch'] = $posted['specialSearch'];
                $options['specialPage'] = $posted['specialPage'];
                $options['specialArchive'] = $posted['specialArchive'];
                $options['specialSingle'] = $posted['specialSingle'];
                
                $options_all[$widget_number] = $options;
            }
            update_option('widget_gdpagesnavigator', $options_all);
            $updated = true;
        }
        
        if (-1 == $number) {
            $wpnm = '%i%';
            $wpno = $this->default_options;
        }
        else {
            $o = $this->upgrade_settings($options_all[$number], $this->default_options);
            $options_all[$number] = $o;
            update_option('widget_gdpagesnavigator', $options_all);
            
            $wpnm = $number;
            $wpno = $options_all[$number];
        }
            
        include("gd-pages-controls.php");
    }

    function upgrade_settings($old, $new) {
        foreach ($new as $key => $value)
            if (!isset($old[$key])) $old[$key] = $value;
        
        $unset = Array();
        foreach ($old as $key => $value)
            if (!isset($new[$key])) $unset[] = $key;
        
        foreach ($unset as $key)
            unset($old[$key]);
        
        return $old;
    }
    
    function render_level_hierarchy($excludeList, $ident = 0, $sort_type = 0, $sort_order = 'ASC', $ul_class = '', $li_class = '') {
        return $this->render_level($excludeList, 0, $ident, false, false, $sort_type, $sort_order, $ul_class, $li_class);
    }
    
    function render_level($excludeList, $rootId = 0, $ident = 0, $top = false, $render_ident = false, $sort_type = 0, $sort_order = 'ASC', $ul_class = '', $li_class = '') {
        $items =  GDPages::get_pages($rootId, $this->sort_types[$sort_type]['value'], $sort_order);
        
        if ($render_ident)
            $result = '<ul style="padding-left:'.$ident.'px" class="'.$ul_class.'">';
        else
            $result = '<ul class="'.$ul_class.'">';
        for ($i = 0; $i < count($items); $i++) {
            if (!in_array($items[$i]["id"], $excludeList)) {
                $result .= '<li class="page_item page-item-'.$items[$i]["id"].' '.$li_class.'"><a title="'.attribute_escape(apply_filters('the_title', __($items[$i]["title"]))).'" href="'.get_page_link($items[$i]["id"]).'">'.attribute_escape(apply_filters('the_title', __($items[$i]["title"]))).'</a></li>';
                if ($items[$i]["subpages"] > 0 && !$top) {
                    if ($render_ident)
                        $ident += $ident;
                    $result .= $this->render_level($excludeList, $items[$i]["id"], $ident, false, true, $sort_type, $sort_order, $this->o["classChildList"], $this->o["classChildItem"]);
                }
            }
        }
        $result .= '</ul>';
        return $result;
    }

    function sorting_options($sort) {
        for ($i = 0; $i < count($this->sort_types); $i++) {
            $title = $this->sort_types[$i]['name'];
            if ($i == $sort)
                $current = ' selected="selected"';
            else
                $current = '';
            echo "\n\t<option value='$i'$current>$title</option>"; 
        }
    }
    
    function render_options($sort_column = "menu_order", $sort_order = "ASC", $selected = array(), $parent = 0, $level = 0, $only_owners = 0) {
        global $wpdb;
        $sql = "SELECT x.id as ID, x.post_parent as post_parent, x.post_title as post_title, count(y.id) as subpages FROM $wpdb->posts x LEFT JOIN $wpdb->posts y ON x.id = y.post_parent WHERE x.post_type = 'page' AND x.post_status = 'publish' AND x.post_parent = $parent GROUP BY x.id, x.post_parent, x.post_title ORDER BY x.$sort_column $sort_order";
        $items = $wpdb->get_results( $sql );

        if ( $items ) {
            foreach ( $items as $item ) {
                if (($only_owners == 1 && $item->subpages > 0) || $only_owners == 0) {
                    $pad = str_repeat( '&nbsp;', $level * 2 );
                    if ( in_array($item->ID, $selected))
                        $current = ' selected="selected"';
                    else
                        $current = '';
        
                    echo "\n\t<option value='$item->ID'$current>$pad $item->post_title</option>";
                    $this->render_options($sort_column, $sort_order, $selected, $item->ID, $level+1, $only_owners);
                }
            }
        } 
        else {
            return false;
        }
    }
}

$gdpg = new GDPagesNavigator();
add_action('init', array($gdpg, 'init'));
add_action('widgets_init', array($gdpg, 'widget_init'));

?>